# Script AII.6.R
datos<-read.csv2("Curva crecimiento.csv",header=TRUE,encoding= "latin1")
attach(datos)
plot(N,r,main="C. vulgaris",
xlab=expression(paste("Nitrato (",paste(mu,"M)"),sep=" ")),
ylab="Growth rate",font.main=4,cex.main=1.25,pch=19)
modeloMM<-nls(r~rmax*N/(Ks+N),start=list(rmax=1.8,Ks=5))
coordx<-seq(0,160,0.01)
coordy<-predict(modeloMM,list(N=coordx))
lines(coordx,coordy)
text(100,0.5,substitute("r"==paste(frac(paste("r"[max]*"S"),
paste("K"[s]+"S")))),cex=1.5)
